local helpers = {
   version = "1.0",
   contributors = {
      "quietly-turning"
   }
}

-- ------------------------------------------------------
local mods_level = "ModsLevel_Song"

-- ------------------------------------------------------
-- function for detecting edit mode
-- returns true or false
helpers.IsEditMode = function()
   local screen = SCREENMAN:GetTopScreen()
   if not screen then
      lua.ReportScriptError("IsEditMode() check failed to run because there is no Screen yet.")
      return nil
   end

   return (THEME:GetMetric(screen:GetName(), "Class") == "ScreenEdit")
end

-- ------------------------------------------------------

helpers.GetNoteField = function(player)

   local topscreen = SCREENMAN:GetTopScreen()
   if not topscreen then
      lua.ReportScriptError("\nA script attempted to call GetNoteField before the screen was finished initializing.  helpers.GetNoteField() should only be called from OnCommand or afterwards.")
      return
   end

   player = player or GAMESTATE:GetMasterPlayerNumber()
   local notefield = nil

   -- Get the player ActorFrame on ScreenGameplay
   -- It's a direct child of the screen and named "PlayerP1" for P1
   -- and "PlayerP2" for P2.
   -- This naming convention is hardcoded in the SM5 engine.
   --
   -- ScreenEdit does not name its player ActorFrame, but we can still find it.

   -- find the player ActorFrame in edit mode
   if helpers.IsEditMode() then
      -- loop through all nameless children of topscreen
      -- and find the one that contains the NoteField
      for _,v in ipairs(topscreen:GetChild("")) do
         if v:GetChild("NoteField") then
            notefield = v:GetChild("NoteField")
            break
         end
      end

   -- find the player ActorFrame in gameplay
   else
      local player_af = topscreen:GetChild("Player"..ToEnumShortString(player))
      if player_af then
         notefield = player_af:GetChild("NoteField")
      end
   end

   return notefield
end

-- ------------------------------------------------------
-- Hide everything but the SongForeground
-- In Simply Love (as of v4.8.5 anyway), player combos will unhide themselves,
-- but that's okay for this stepchart.  If you need to hide combos in SL, call
-- hibernate(math.huge) on each.  Sorry about that.

helpers.OnlyShowFG = function()
   local screen = SCREENMAN:GetTopScreen()
   if not screen then
      lua.ReportScriptError("OnlyShowFG() failed to run because there is no Screen yet.")
      return nil
   end

   local layers = screen:GetChildren()

   for name,layer in pairs(layers) do
      if name ~= "SongForeground" then
         layer:visible(false)
      end
   end
end

-- ------------------------------------------------------
local player_options = {}
for player in ivalues(GAMESTATE:GetHumanPlayers()) do
   player_options[player] = GAMESTATE:GetPlayerState(player):GetPlayerOptions(mods_level)
end

-- TODO: document the structure of mod_table...
helpers.ApplyMod = function(mod_table)
   for modifier in ivalues(mod_table) do

      local modifier, args, players = unpack(modifier)
      local value, approach_speed = nil, nil

      if type(args) == "table" then
         value, approach_speed = unpack(args)
      elseif type(args) ~= "function" then
         value = args
         approach_speed = 9999 -- instantaneous? I don't understand approach_speed ._.
      end

      players = players or GAMESTATE:GetHumanPlayers()

      if type(players) == "table" then
         for player in ivalues( players ) do
            player_options[player][modifier](player_options[player], value, approach_speed)
         end
      else
         player_options[players][modifier](player_options[players], value, approach_speed)
      end
   end
end


-- ------------------------------------------------------
-- store the players' starting mods as soon as this ModChartHelpers module is loaded
local original_mods = {}
for player in ivalues(GAMESTATE:GetHumanPlayers()) do
   local ps = GAMESTATE:GetPlayerState(player)
   original_mods[player] = ps:GetPlayerOptionsString(mods_level)

   -- "mmods can't be tweened"
   -- so use CMods, I guess?
   local mmod, _ = ps:GetPlayerOptions(mods_level):MMod()
   if mmod then
      original_mods[player] = original_mods[player]:gsub("m%d+", ("C"..mmod))
   end
end

-- function that can restore players' mods to their original configuration
helpers.RestoreOriginalMods = function()
   for player in ivalues(GAMESTATE:GetHumanPlayers()) do
      GAMESTATE:GetPlayerState(player):SetPlayerOptions(mods_level, original_mods[player])
   end
end

-- ------------------------------------------------------


helpers.ForegroundAF = function(actions)

   local cur_action = 1

   local Update = function(af, dt)
      if cur_action <= #actions and GAMESTATE:GetSongBeat() > actions[cur_action][1] then
         actions[cur_action][2](af)
         cur_action = cur_action + 1
      end
   end

   return Def.ActorFrame({
      OnCommand=function(self)
         -- don't activate FGChanges in EditMode
         if helpers.IsEditMode() then return end

         self:SetUpdateFunction( Update )
      end,

      -- actor that sleeps for a long time
      -- needed to keep Foreground layer "alive"
      Def.Actor({ InitCommand=function(self) self:sleep(99999) end})
   })
end

-- ------------------------------------------------------
return helpers